/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class PHPContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private IContextInformation fContextInformation;
    private int fInitialOffset;
    private ITextViewer fViewer;
    private int fCurrentParameter;

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this.fContextInformation = info;
        this.fViewer = viewer;
        this.fInitialOffset = info instanceof IContextInformationExtension ? ((IContextInformationExtension)info).getContextInformationPosition() : offset - 1;
        ++this.fInitialOffset;
        this.fCurrentParameter = -1;
    }

    public boolean isContextInformationValid(int offset) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (offset >= this.fInitialOffset) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            document = this.fViewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this.fInitialOffset);
            if (offset >= line.getOffset() && offset < document.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this.fInitialOffset, offset, "(", ")", false) >= 0;
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(this.fViewer.getDocument(), this.fInitialOffset, offset, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        String s = this.fContextInformation.getInformationDisplayString();
        int[] commas = this.computeCommaPositions(s);
        if (commas.length - 2 < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        int start = commas[this.fCurrentParameter] + 1;
        int end = commas[this.fCurrentParameter + 1];
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
        }
        return true;
    }

    private int getCharCount(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        while (start < end) {
            char c = document.getChar(start);
            if (Character.isWhitespace(c)) {
                ++start;
                continue;
            }
            if (c != '(') break;
            ++start;
            break;
        }
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block12: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '/': {
                    if (offset >= end) continue block12;
                    char next = document.getChar(offset);
                    if (next == '*') {
                        offset = this.getCommentEnd(document, offset + 1, end);
                        break;
                    }
                    if (next != '/') continue block12;
                    int nextLine = document.getLineOfOffset(offset) + 1;
                    if (nextLine == document.getNumberOfLines()) {
                        offset = end;
                        break;
                    }
                    offset = document.getLineOffset(nextLine);
                    break;
                }
                case '*': {
                    char next;
                    if (offset >= end || (next = document.getChar(offset)) != '/') continue block12;
                    charCount = 0;
                    ++offset;
                    break;
                }
                case '\"': 
                case '\'': {
                    offset = this.getStringEnd(document, offset, end, curr);
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block12;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block12;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block12;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block12;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block12;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    private int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(new Integer(-1));
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(new Integer(pos));
                    break;
                }
                case '[': {
                    pos = code.indexOf(93, pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(new Integer(length));
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }
}

